#include<bits/stdc++.h>
#define int long long
#define sz(a) (int)a.size()

using namespace std;

struct pt{
    int x, y;
};

struct seg{
    pt p1, p2, dp;
};

int cP(pt a, pt b) {
    int ret = a.x * b.y - a.y * b.x;
    if (ret == 0) return 0;
    if (ret > 0) return 1;
    return -1;
}

bool eq(pt a, pt b) {
    return a.x == b.x && a.y == b.y;
}

bool isect(seg a, seg b) {
    if (eq(a.p1, b.p1) || eq(a.p1, b.p2) || eq(a.p2, b.p1) || eq(a.p2, b.p2)) return 1;
    pt s1, s2;
    s1.x = b.p1.x - a.p1.x;
    s1.y = b.p1.y - a.p1.y;
    s2.x = b.p2.x - a.p1.x;
    s2.y = b.p2.y - a.p1.y;
    int u1 = cP(a.dp, s1), u2 = cP(a.dp, s2);
    int f1 = u1 * u2;
    s1.x = a.p1.x - b.p1.x;
    s1.y = a.p1.y - b.p1.y;
    s2.x = a.p2.x - b.p1.x;
    s2.y = a.p2.y - b.p1.y;
    int u3 = cP(b.dp, s1), u4 = cP(b.dp, s2);
    int f2 = u3 * u4;
    if (u1 == 0 && u2 == 0 && u3 == 0 && u4 == 0) return 0;
    return f1 <= 0 && f2 <= 0;
}

vector<int> pr;

int get(int x) {
    if (x == pr[x]) return x;
    int ret = get(pr[x]);
    pr[x] = ret;
    return ret;
}

void unite(int a, int b) {
    a = get(a);
    b = get(b);
    if (a != b) {
        if (rand() & 1) {
            pr[a] = b;
        }
        else {
            pr[b] = a;
        }
    }
}

void solve() {
    int n;
    cin >> n;
    vector<seg> a(n);
    pr.clear();
    pr.resize(n);
    for (int i = 0; i < n; ++i) {
        pr[i] = i;
    }
    for (int i = 0; i < n; ++i) {
        pt p1, p2;
        cin >> p1.x >> p1.y >> p2.x >> p2.y;
        a[i].p1 = p1;
        a[i].p2 = p2;
        a[i].dp.x = p2.x - p1.x;
        a[i].dp.y = p2.y - p1.y;
    }
    vector<int> cnt(n);
    int ans = 0;
    for (int i = 1; i < n; ++i) {
        for (int j = 0; j < i; ++j) {
            if (isect(a[i], a[j])) {
                cnt[get(j)]++;
            }
        }
        for (int j = 0; j < n; ++j) {
            if (cnt[j] > 1) {
                ans += cnt[j] - 1;
            }
        }
        for (int j = 0; j < i; ++j) {
            if (isect(a[i], a[j])) {
                unite(i, j);
            }
        }
        fill(cnt.begin(), cnt.end(), 0);
    }
    cout << ans + 1 << '\n';
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}
